!
      program alitime_fgmpos
!
! -----------------------------------------------------------------------------
! Frame   : Procedures and program used in JGR data report 
!           "Use of twenty years CLUSTER/FGM data to observe the mean behavior 
!           of the magnetic field and current density of Earth's magnetosphere" 
!           By P. Robert and M. Dunlop, October 2021
!
! Program : alitime_fgmpos
! Object  : create 4 C*_FGM_SPIN_aligned_20101010.dat files
!           from   4 C*_FGM_SPIN_20101010.dat files
! Input   : list of 4 sat groups of C*_FGM_SPIN_xxxxxxxx.dat files
!           Directory FGMPOS_ali/2010/2010_01 must exist berore run.
! Output  : list of 4 sat groups of C*_FGM_SPIN_aligned_xxxxxxxx.dat files
!           put on FGMPOS_ali/yyyy/yyyy_mm
! Author  : P. Robert, LPP-ScientiDev, 2020-Oct.2021
! Mail    : patrick.robert@lpp.polytechnique.fr
! -----------------------------------------------------------------------------


! *** declaration des variables

      real(kind=4),      dimension(:,:),   allocatable :: bmag1
      real(kind=4),      dimension(:,:),   allocatable :: bmag2
      real(kind=4),      dimension(:,:),   allocatable :: bmag3
      real(kind=4),      dimension(:,:),   allocatable :: bmag4
      
      real(kind=4),      dimension(:,:),   allocatable :: posi1
      real(kind=4),      dimension(:,:),   allocatable :: posi2
      real(kind=4),      dimension(:,:),   allocatable :: posi3
      real(kind=4),      dimension(:,:),   allocatable :: posi4
    
      character(len=24), dimension(:),     allocatable :: datiso1
      character(len=24), dimension(:),     allocatable :: datiso2
      character(len=24), dimension(:),     allocatable :: datiso3
      character(len=24), dimension(:),     allocatable :: datiso4
      character(len=24), dimension(:),     allocatable :: datisoa
      
      character(len=255), dimension(4) :: file_in, file_outp,file_out
      
!     ---------------------------------------------------------------+--

      print 200
      print 200, ('X',i=1,53)
      print 200
      print 200, 'alitime_fgmpos.exe: time alignment of 4 fgmpos files'
      print 200
      print 200, '                        Patrick Robert, juill 2021'
      print 200
      print 200, ('X',i=1,53)
      print 200

  200 format(80a)
!
!     ---------------------------------------------------------------+--
  DO nfile=1,10000
!     ---------------------------------------------------------------+--

      print*, "================================================================================="
      print*, 'lecture des fichiers  du groupe',nfile

      read(*,'(a)',iostat=ios) file_in(1)
      if(ios /= 0) exit
      read(*,'(a)') file_in(2)
      read(*,'(a)') file_in(3)
      read(*,'(a)') file_in(4) 
      
      print*, 'file_in1=',TRIM(file_in(1))
      print*, 'file_in2=',TRIM(file_in(2))
      print*, 'file_in3=',TRIM(file_in(3))
      print*, 'file_in4=',TRIM(file_in(4))
      
      DO i=1,4
         ii=LEN_TRIM(file_in(i))
         file_outp(i)=file_in(i)(1:ii-4)//'_ali.dat'
         ii=index(file_outp(i),'/',back=.true.)
         file_outp(i)=file_outp(i)(ii+1:)
      ENDDO

      if(file_outp(1)(2:2) /= '1') stop 'file 1 is not a C1'
      if(file_outp(2)(2:2) /= '2') stop 'file 2 is not a C2'
      if(file_outp(3)(2:2) /= '3') stop 'file 3 is not a C3'
      if(file_outp(4)(2:2) /= '4') stop 'file 4 is not a C4'

! C1_FGM_SPIN_20010107_ali.dat

      read(file_outp(1),'(12x,i4,2i2)') iyear,imon,iday

      write(file_out(1),'(a,i4,a,i4,a,i2.2,2a)') 'FGMPOS_ali/',iyear,'/',iyear,'_',imon,'/',file_outp(1)(1:28)      
      write(file_out(2),'(a,i4,a,i4,a,i2.2,2a)') 'FGMPOS_ali/',iyear,'/',iyear,'_',imon,'/',file_outp(2)(1:28)      
      write(file_out(3),'(a,i4,a,i4,a,i2.2,2a)') 'FGMPOS_ali/',iyear,'/',iyear,'_',imon,'/',file_outp(3)(1:28)      
      write(file_out(4),'(a,i4,a,i4,a,i2.2,2a)') 'FGMPOS_ali/',iyear,'/',iyear,'_',imon,'/',file_outp(4)(1:28)      

      print*
      print*, 'file_ou1=',TRIM(file_out(1))
      print*, 'file_ou2=',TRIM(file_out(2))
      print*, 'file_ou3=',TRIM(file_out(3))
      print*, 'file_ou4=',TRIM(file_out(4))
      print*, "================================================================================="
      
   ierr=0
   DO ic=1,4

      open(ic,file=file_in(ic),form='unformatted') 
      
      if(ic == 1) then
                 read(ic,iostat=iosta) nbloc1
                 print*, 'read ',trim(file_in(ic)),'  nbloc1=',nbloc1
                 if(nbloc1 ==0) then
                    ierr=1
                    exit
                 endif
      if(allocated(datiso1)) deallocate(datiso1)
      if(allocated(bmag1)) deallocate(bmag1)
      if(allocated(posi1)) deallocate(posi1)
                 allocate(datiso1(nbloc1))
                 allocate(bmag1(3,nbloc1))
                 allocate(posi1(3,nbloc1))
                 do i=1,nbloc1
                 read(ic,iostat=iosta) datiso1(i),Bmag1(1,i),Bmag1(2,i),Bmag1(3,i),Posi1(1,i),Posi1(2,i),Posi1(3,i)
                 if(iosta /= 0) then
                    print*, 'i, iosta=',i,iosta
                    stop 'pb val nbloc1'
                 endif
                 enddo
      endif
      
      if(ic == 2) then
                 read(ic,iostat=iosta) nbloc2
                 print*, 'read ',trim(file_in(ic)),'  nbloc2=',nbloc2
                 if(nbloc2 ==0) then
                    ierr=1
                    exit
                 endif
      if(allocated(datiso2)) deallocate(datiso2)
      if(allocated(bmag2)) deallocate(bmag2)
      if(allocated(posi2)) deallocate(posi2)
                 allocate(datiso2(nbloc2))
                 allocate(bmag2(3,nbloc2))
                 allocate(posi2(3,nbloc2))
                 do i=1,nbloc2
                 read(ic,iostat=iosta) datiso2(i),Bmag2(1,i),Bmag2(2,i),Bmag2(3,i),Posi2(1,i),Posi2(2,i),Posi2(3,i)
                 if(iosta /= 0) then
                    print*, 'i, iosta=',i,iosta
                    stop 'pb val nbloc2'
                 endif
                 enddo
      endif      
      
      if(ic == 3) then
                 read(ic,iostat=iosta) nbloc3
                 print*, 'read ',trim(file_in(ic)),'  nbloc3=',nbloc3
                 if(nbloc3 ==0) then
                    ierr=1
                    exit
                 endif
      if(allocated(datiso3)) deallocate(datiso3)
      if(allocated(bmag3)) deallocate(bmag3)
      if(allocated(posi3)) deallocate(posi3)
                 allocate(datiso3(nbloc3))
                 allocate(bmag3(3,nbloc3))
                 allocate(posi3(3,nbloc3))
                 do i=1,nbloc3
                 read(ic,iostat=iosta) datiso3(i),Bmag3(1,i),Bmag3(2,i),Bmag3(3,i),Posi3(1,i),Posi3(2,i),Posi3(3,i)
                 if(iosta /= 0) then
                    print*, 'i, iosta=',i,iosta
                    stop 'pb val nbloc3'
                 endif
                 enddo
      endif
      
      if(ic == 4) then
                 read(ic,iostat=iosta) nbloc4
                 print*, 'read ',trim(file_in(ic)),'  nbloc4=',nbloc4
                 if(nbloc4 ==0) then
                    ierr=1
                    exit
                 endif
      if(allocated(datiso4)) deallocate(datiso4)
      if(allocated(bmag4)) deallocate(bmag4)
      if(allocated(posi4)) deallocate(posi4)
                 allocate(datiso4(nbloc4))
                 allocate(bmag4(3,nbloc4))
                 allocate(posi4(3,nbloc4))
                 do i=1,nbloc4
                 read(ic,iostat=iosta) datiso4(i),Bmag4(1,i),Bmag4(2,i),Bmag4(3,i),Posi4(1,i),Posi4(2,i),Posi4(3,i)
                 if(iosta /= 0) then
                    print*, 'i, iosta=',i,iosta
                    stop 'pb val nbloc4'
                 endif
                 enddo
      endif
      
      close(ic)
      
   ENDDO
   
   if(ierr == 1) cycle
   
!     ---------------------------------------------------------------+--      

      print*, 'time alignment of 4 datasets'
            
      fill_val=1.e30
      dt1=4.
      dt2=4.
      dt3=4.
      dt4=4.
  
      call alitime_fgmpos_data_4sat(datiso1,datiso2,datiso3,datiso4, &
                             bmag1,bmag2,bmag3,bmag4, &
                             Posi1,Posi2,Posi3,Posi4, &
                              nbloc1, nbloc2, nbloc3, nbloc4, &
                              dt1,dt2,dt3,dt4,iref,nbpint,fill_val)

!     ---------------------------------------------------------------+-- 

      print*, 'create a binary indexed  file time aligned'
      
      if(allocated(datisoa)) deallocate(datisoa)
      allocate(datisoa(nbpint))

      if(iref == 1) then
                    datisoa=datiso1
      endif
      
      if(iref == 2) then
                    datisoa=datiso2
      endif
      
      if(iref == 3) then
                    datisoa=datiso3
      endif
      
      if(iref == 4) then
                    datisoa=datiso4
      endif
     
      
!     S/C 1
!     ----- 

      open(1,file=file_out(1),form='unformatted')
      write(1) nbpint
      do i=1,nbpint
         write(1) datisoa(i),bmag1(1,i),bmag1(2,i),bmag1(3,i),Posi1(1,i),Posi1(2,i),Posi1(3,i)
      enddo
      close(1)


!     S/C 2
!     -----

      open(2,file=file_out(2),form='unformatted')
      write(2) nbpint
      do i=1,nbpint
         write(2) datisoa(i),bmag2(1,i),bmag2(2,i),bmag2(3,i),Posi2(1,i),Posi2(2,i),Posi2(3,i)
      enddo
      close(2)

!     S/C 3
!     -----

      open(3,file=file_out(3),form='unformatted')
      write(3) nbpint
      do i=1,nbpint
         write(3) datisoa(i),bmag3(1,i),bmag3(2,i),bmag3(3,i),Posi3(1,i),Posi3(2,i),Posi3(3,i)
      enddo
      close(3)
      
!     S/C 4
!     -----

      open(4,file=file_out(4),form='unformatted')
      write(4) nbpint
      do i=1,nbpint
         write(4) datisoa(i),bmag4(1,i),bmag4(2,i),bmag4(3,i),Posi4(1,i),Posi4(2,i),Posi4(3,i)
      enddo
      close(4)




      
ENDDO
     
      print*, 'alitime_fgmpos.exe                : NORMAL TERMINATION'
             stop 'alitime_fgmpos.exe            : NORMAL TERMINATION'
!
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX


