!
      program cocurl_from_fgmpos_ali
      
  
! -----------------------------------------------------------------------------
! Frame   : Procedures and program used in JGR data report 
!           "Use of twenty years CLUSTER/FGM data to observe the mean behavior 
!           of the magnetic field and current density of Earth's magnetosphere" 
!           By P. Robert and M. Dunlop, October 2021
!
! Program : cocurl_from_fgmpos_ali.f90
! Object  : Compte curl, div etc. from full list of files of FGMPOS_aligned_database
! Input   : file list_aligned.txt (contains path of group of 4 FGPOS_aligned files)
! Output  : Curl_FGM_SPIN files in directories Curl_Div_database_raw, Curl_Div_database-dip, 
!           Curl_Div_database-igrf. These directories MUST be existing before run
!           and subdirectories yyyy/yyyy_mm too.
! Author  : P. Robert, LPP-ScientiDev, 2020-Oct.2021
! Mail    : patrick.robert@lpp.polytechnique.fr
! -----------------------------------------------------------------------------


      real(kind=4),      dimension(:,:),   allocatable :: bmag1
      real(kind=4),      dimension(:,:),   allocatable :: bmag2
      real(kind=4),      dimension(:,:),   allocatable :: bmag3
      real(kind=4),      dimension(:,:),   allocatable :: bmag4

      real(kind=4),      dimension(:,:),   allocatable :: posi1
      real(kind=4),      dimension(:,:),   allocatable :: posi2
      real(kind=4),      dimension(:,:),   allocatable :: posi3
      real(kind=4),      dimension(:,:),   allocatable :: posi4
      
      character(len=24), dimension(:),     allocatable :: datisoa   
      
      real(kind=4), dimension(4) :: Px,Py,Pz,Bx,By,Bz
      real (kind=4) :: satmag(3,4), satpos(3,4), satmago(3,4)


      character(len=255), dimension(4) :: file_in
      character(len=255) :: file_out1,file_out2,file_out3,work
      character(len=255) :: Fbasename
      
      RE=6372.2
!
!     ---------------------------------------------------------------+--
  DO nfile=1,20000 ! full list of files of Big_FGMPOS_ali database
!     ---------------------------------------------------------------+--

      print*, "================================================================================="
      print*, 'reading 4 FGMPOS_ali.dat of group # ',nfile
      
      ! ex: C4_FGM_SPIN_20020922_ali.dat

      read(*,'(a)',iostat=iosta) file_in(1)
      if(iosta /=0 ) exit
      read(*,'(a)') file_in(2)
      read(*,'(a)') file_in(3)
      read(*,'(a)') file_in(4)
 ! if(nfile < 4805) cycle

      print*
      print*, 'file_in1=',TRIM(file_in(1))
      print*, 'file_in2=',TRIM(file_in(2))
      print*, 'file_in3=',TRIM(file_in(3))
      print*, 'file_in4=',TRIM(file_in(4))
      print*
         
      work=Fbasename(file_in(1))
      if(work(2:2) /= '1') stop 'file 1 is not a C1'
      
      work=Fbasename(file_in(2))
      if(work(2:2) /= '2') stop 'file 2 is not a C2'
      
      work=Fbasename(file_in(3))
      if(work(2:2) /= '3') stop 'file 3 is not a C3'
      
      work=Fbasename(file_in(4))
      if(work(2:2) /= '4') stop 'file 4 is not a C4'

      file_out1= 'Curl_Div_database_raw/'//work(13:16)//'/'// &
             work(13:16)//'_'//work(17:18)//'/Curl_FGM_SPIN_'//work(13:20)//'.dat'
      print*, 'file_out1=',TRIM(file_out1)
      
      file_out2= 'Curl_Div_database-dip/'//work(13:16)//'/'// &
             work(13:16)//'_'//work(17:18)//'/Curl_FGM_SPIN_'//work(13:20)//'.dat'
      print*, 'file_out2=',TRIM(file_out2)
      
      file_out3= 'Curl_Div_database-igrf/'//work(13:16)//'/'// &
             work(13:16)//'_'//work(17:18)//'/Curl_FGM_SPIN_'//work(13:20)//'.dat'
      print*, 'file_out3=',TRIM(file_out3)
      
! deallocate previous allocation

     if(allocated(datisoa)) deallocate(datisoa)
     
     if(allocated(bmag1)) deallocate(bmag1)
     if(allocated(bmag2)) deallocate(bmag2)
     if(allocated(bmag3)) deallocate(bmag3)
     if(allocated(bmag4)) deallocate(bmag4)
     
     if(allocated(posi1)) deallocate(posi1)
     if(allocated(posi2)) deallocate(posi2)
     if(allocated(posi3)) deallocate(posi3)
     if(allocated(posi4)) deallocate(posi4)


      print*
      print*, 'reading 4 FGMPOS_ali.dat'

!     S/C 1
!     -----

      open(1,file=file_in(1),form='unformatted')
      read(1) nbpint
      
      allocate(datisoa(nbpint))
      allocate(bmag1(3,nbpint))
      allocate(posi1(3,nbpint))            
                 
      do i=1,nbpint
         read(1) datisoa(i),bmag1(1,i),bmag1(2,i),bmag1(3,i),Posi1(1,i),Posi1(2,i),Posi1(3,i)
      enddo
      close(1)


!     S/C 2
!     -----

      open(2,file=file_in(2),form='unformatted')
      read(2) nbpint2
      
      if(nbpint2 /= nbpint) stop 'SC2 no time_aligned'
      
      allocate(bmag2(3,nbpint))
      allocate(posi2(3,nbpint))
      
      do i=1,nbpint
         read(2) datisoa(i),bmag2(1,i),bmag2(2,i),bmag2(3,i),Posi2(1,i),Posi2(2,i),Posi2(3,i)
      enddo
      close(2)

!     S/C 3
!     -----

      open(3,file=file_in(3),form='unformatted')
      read(3) nbpint3
            
      if(nbpint3 /= nbpint) stop 'SC3 no time_aligned'

      allocate(bmag3(3,nbpint))
      allocate(posi3(3,nbpint))
      
      do i=1,nbpint
         read(3) datisoa(i),bmag3(1,i),bmag3(2,i),bmag3(3,i),Posi3(1,i),Posi3(2,i),Posi3(3,i)
      enddo
      close(3)

!     S/C 4
!     -----

      open(4,file=file_in(4),form='unformatted')
      read(4) nbpint4
            
      if(nbpint4 /= nbpint) stop 'SC4 no time_aligned'

      allocate(bmag4(3,nbpint))
      allocate(posi4(3,nbpint))
      
      do i=1,nbpint
         read(4) datisoa(i),bmag4(1,i),bmag4(2,i),bmag4(3,i),Posi4(1,i),Posi4(2,i),Posi4(3,i)
      enddo
      close(4)
      


!     ---------------------------------------------------------------+--
      print*, 'Curl & Div computation from 4-files group'
!     ---------------------------------------------------------------+--

         
      open(7,file=file_out1)
      open(8,file=file_out2)
      open(9,file=file_out3)
      
      write(7,*) nbpint
      write(8,*) nbpint
      write(9,*) nbpint
      
      DO i=1,nbpint ! all file records
      
      call decode_datiso(datisoa(i),iyear,imon,iday,ih,im,is,ims,imc)
      call ctimpar(iyear,imon,iday,ih,im,is)
      call cdoyear(iyear,imon,iday,idoty)

      VGSEX=-400.0 
      VGSEY=0.
      VGSEZ=0.
      call RECALC_08 (IYEAR,idoty,ih,im,is,VGSEX,VGSEY,VGSEZ)
      call GDIPTIL(diptan)
      diptan=diptan*180./3.14159
      
      call g_gsm_dipole_tilt_angle(diptanR)
      diptanR=diptanR*180./3.14159
      
      if(abs(diptanR-diptan) > 1. ) then
                     print*, '***** WARNING diptanR,diptan=',diptanR,diptan,diptanR-diptan
      endif
 
      satpos(1,1)=Posi1(1,i)
      satpos(2,1)=Posi1(2,i)
      satpos(3,1)=Posi1(3,i)
      
      satpos(1,2)=Posi2(1,i)
      satpos(2,2)=Posi2(2,i)
      satpos(3,2)=Posi2(3,i)
      
      satpos(1,3)=Posi3(1,i)
      satpos(2,3)=Posi3(2,i)
      satpos(3,3)=Posi3(3,i)
      
      satpos(1,4)=Posi4(1,i)
      satpos(2,4)=Posi4(2,i)
      satpos(3,4)=Posi4(3,i)
      
      
      satmag(1,1)=bmag1(1,i)
      satmag(2,1)=bmag1(2,i)
      satmag(3,1)=bmag1(3,i)
      
      satmag(1,2)=bmag2(1,i)
      satmag(2,2)=bmag2(2,i)
      satmag(3,2)=bmag2(3,i)
      
      satmag(1,3)=bmag3(1,i)
      satmag(2,3)=bmag3(2,i)
      satmag(3,3)=bmag3(3,i)
      
      satmag(1,4)=bmag4(1,i)
      satmag(2,4)=bmag4(2,i)
      satmag(3,4)=bmag4(3,i)
      
!--------------

      rr1=sqrt(satpos(1,1)**2 +satpos(2,1)**2 +satpos(3,1)**2)
      rr2=sqrt(satpos(1,2)**2 +satpos(2,2)**2 +satpos(3,2)**2)
      rr3=sqrt(satpos(1,3)**2 +satpos(2,3)**2 +satpos(3,3)**2)
      rr4=sqrt(satpos(1,4)**2 +satpos(2,4)**2 +satpos(3,4)**2)

      if(rr1 <  RE .or. rr2 < RE .or. rr3 < RE .or. rr4 < RE) cycle 
      
      Px(:)=satpos(1,:)
      Py(:)=satpos(2,:)
      Pz(:)=satpos(3,:)

! -------------------------------------------------
!     ici   pour le calcul de J , soit rien, soit -Dip, soit -IGRF
!     cocurldiv:
!     input:  satpos en km, satmag en nT
!     output: J en nA/m2 et div en nT/m, ajb en degres
! -------------------------------------------------

!       sauvegarde du champ initial

        satmago(:,:)=satmag(:,:)
        
      DO icas=1,3
      
      if (icas  == 1) then
         call cocurldiv(satpos,satmag,Gjx1,Gjy1,Gjz1,curl1,div1,ajb1,elong,plana)
      endif
      
      if(icas ==2 ) then
         call   substrac_dip(satpos,satmag)
         call cocurldiv(satpos,satmag,Gjx2,Gjy2,Gjz2,curl2,div2,ajb2,elong,plana)
      endif
      
      if(icas ==3 ) then
         satmag(:,:)=satmago(:,:)
         call   substrac_igrf(satpos,satmag)
         call cocurldiv(satpos,satmag,Gjx3,Gjy3,Gjz3,curl3,div3,ajb3,elong,plana)
      endif

!
! -------------------------------------------------
!     print*, 'writing results'
! -------------------------------------------------

      Bx(:)=satmag(1,:)
      By(:)=satmag(2,:)
      Bz(:)=satmag(3,:)

      if (icas  == 1) write(7,200)  datisoa(i),Px,Py,Pz,Bx,By,Bz,GJx1,GJy1,GJz1,curl1,div1,ajb1,elong,plana,diptan
      if (icas  == 2) write(8,200)  datisoa(i),Px,Py,Pz,Bx,By,Bz,GJx2,GJy2,GJz2,curl2,div2,ajb2,elong,plana,diptan
      if (icas  == 3) write(9,200)  datisoa(i),Px,Py,Pz,Bx,By,Bz,GJx3,GJy3,GJz3,curl3,div3,ajb3,elong,plana,diptan
      
      ENDDO ! icas

      ENDDO ! all file records
      
      close(7)
      close(8)
      close(9)
      
 200 format(a24,/,12E14.6,/,12E14.6,/,6E11.3,2E10.2,E11.3)
 
     ENDDO

  write(*,*) '    cocurl_from_fgmpos_ali.exe        : NORMAL TERMINATION'
            stop 'cocurl_from_fgmpos_ali.exe        : NORMAL TERMINATION'
  end
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX

  function Fbasename(path)

!----------------------------------------------------------------------!
! Object: Return file name of a path
! Author: P. Robert , LPP, 2011 March 08
!----------------------------------------------------------------------!

  character(len=*)   :: path
  character(len=255) :: ligne, Fbasename

! ------------------------------------------

  ligne=path

  np=LEN_TRIM(path)

! recherche du dernier "/"

  do i=1,np
     ns=INDEX(ligne,"/")
     ligne=ligne(ns+1:np)
  enddo

  Fbasename=ligne

  return
  end


!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX

      subroutine substrac_dip(satpos,satmag)
     
      real  satmag(3,4),satpos(3,4)
      
      RE=6372.2

      do isat=1,4

!       on retire le    dipole    

!   (3) IF NO   INFORMATION IS AVAILABLE ON THE SOLAR WIND SPEED, THEN SET VGSEX=-400.0
!       AND VGSEY=VGSEZ=0. IN THAT CASE,    THE GSW COORDINATE SYSTEM BECOMES
!       IDENTICAL TO    THE STANDARD ONE.

        call t_gse_to_gsm(satpos(1,isat),satpos(2,isat),satpos(3,isat),XGSW,YGSW,ZGSW)
        XGSW=XGSW/RE
        YGSW=YGSW/RE
        ZGSW=ZGSW/RE
        
        call DIP_08 (XGSW,YGSW,ZGSW,BXGSW,BYGSW,BZGSW)
        call t_gsm_to_gse(BXGSW,BYGSW,BZGSW,Bdx,Bdy,Bdz)

        satmag(1,isat)=satmag(1,isat)   -Bdx
        satmag(2,isat)=satmag(2,isat)   -Bdy
        satmag(3,isat)=satmag(3,isat)   -Bdz

      enddo
      
      return
      end
      
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX

      subroutine substrac_igrf(satpos,satmag)
     
      real  satmag(3,4),satpos(3,4)
      
      RE=6372.2

      do isat=1,4

!       on retire l'IGRF         

!   (3) IF NO   INFORMATION IS AVAILABLE ON THE SOLAR WIND SPEED, THEN SET VGSEX=-400.0
!       AND VGSEY=VGSEZ=0. IN THAT CASE,    THE GSW COORDINATE SYSTEM BECOMES
!       IDENTICAL TO    THE STANDARD ONE. 

        call t_gse_to_gsm(satpos(1,isat),satpos(2,isat),satpos(3,isat),XGSW,YGSW,ZGSW)
        XGSW=XGSW/RE
        YGSW=YGSW/RE
        ZGSW=ZGSW/RE
        call IGRF_GSW_08 (XGSW,YGSW,ZGSW,HXGSW,HYGSW,HZGSW)
        call t_gsm_to_gse(HXGSW,HYGSW,HZGSW,Bdx,Bdy,Bdz)

        satmag(1,isat)=satmag(1,isat)   -Bdx
        satmag(2,isat)=satmag(2,isat)   -Bdy
        satmag(3,isat)=satmag(3,isat)   -Bdz

      enddo
      return
      end

!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
       SUBROUTINE GDIPTIL(PS)
!
!-----INPUT PARAMETERS:  NONE
!-----OUTPUT PARAMETERS: PS - GEODIPOLE TILT ANGLE IN RADIANS
!
!     ATTENTION:  SUBROUTINE  RECALC  MUST BE INVOKED BEFORE GDIPTIL IN
!     TWO CASES:
!     /A/  BEFORE THE FIRST INVOCATION OF GDIPTIL
!     /B/  IF THE VALUES OF IYEAR,IDAY,IHOUR,MIN,ISEC HAVE BEEN CHANGED
!
!     P. Robert, June 2002.
!
!                      ----------------------
!
      COMMON /GEOPACK1/ A(12),DS3,BB(2),PSI,CC(18)
!
      PS=PSI
!
      RETURN
      END
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX


