  program crea_grid_B_ini_igrf
  
! -----------------------------------------------------------------------------
! Frame   : Procedures and program used in JGR data report 
!           "Use of twenty years CLUSTER/FGM data to observe the mean behavior 
!           of the magnetic field and current density of Earth's magnetosphere" 
!           By P. Robert and M. Dunlop, October 2021
!
! Program : crea_grid_B_ini-igrf.f90
! Object  : Compute B 3D grid from FGMPOS_database
! Input   : file containig all FGM_POS.dat files
! Output  : B 3D grid file
! Author  : P. Robert, LPP-ScientiDev, 2020-Oct.2021
! Mail    : patrick.robert@lpp.polytechnique.fr
! -----------------------------------------------------------------------------


  character(len=255) :: file_fgmpos,datafileB
  character(len=24) datiso


  character(len=3)  :: cdta

  real(kind=4), dimension(:,:,:,:,:), allocatable :: gridB
  integer,      dimension(:,:,:,:),   allocatable :: nvalB
  real(kind=4), dimension(9) :: sw

  x1=-20.
  x2= 20.
  y1=-20.
  y2= 20.
  z1=-20.
  z2= 20.

  dx= 0.25
  dy= 0.25
  dz= 0.25

  nx= int((x2-x1)/dx +0.5)
  ny= int((y2-y1)/dy +0.5)
  nz= int((z2-z1)/dz +0.5)

  print*, '-----------------------------------------------------------------'
  print*, 'nx,ny,nz=',nx,ny,nz

  deltax=float(nx)*dx
  deltay=float(ny)*dy
  deltaz=float(nz)*dz

  difx=(x2-x1)-deltax
  if(abs(difx) > 1.e-10) then
     print*, 'x2-x1 =',x2-x1
     print*, 'deltax=',deltax
     print*, 'diff  =',difx
     print*, '***incoherence! aborted!!'
     stop '***incoherence! aborted!!'
  endif

  dify=(y2-y1)-deltay
  if(abs(dify) > 1.e-10) then
     print*, 'y2-y1 =',y2-y1
     print*, 'deltay=',deltay
     print*, 'diff  =',dify
     print*, '***incoherence! aborted!!'
     stop '***incoherence! aborted!!'
  endif

  difz=(z2-z1)-deltaz
  if(abs(difz) > 1.e-10) then
     print*, 'z2-z1 =',z2-z1
     print*, 'deltaz=',deltaz
     print*, 'diff  =',difz
     print*, '***incoherence! aborted!!'
     stop '***incoherence! aborted!!'
  endif

  allocate(gridB(4,nx,ny,nz,9))

  allocate(nvalB(nx,ny,nz,9))

  gridB(:,:,:,:,:)=0.
  
  nvalB(:,:,:,:)=0

! ---------------
! read files fgmpos*.dat
! ---------------

  iosta=0
  nt=0
  igx=0
  igy=0
  igz=0
  sw(:)=0.
  nf=0

  DO while (iosta == 0)
  print*, '------------------------------------------------------------------------'
  print*, 'path of file to read ? (ex: FGMPOS.dat)'
  read(*,'(a)', iostat=iosta) file_fgmpos
  if(iosta /= 0) go to 30
  if(file_fgmpos(1:5) == '     ') go to 30
  print*, trim(file_fgmpos)
  
  open(1, file=file_fgmpos,form='unformatted')
  nf=nf+1
  
! lecture de chaque enregistrement

  read(1,iostat=iosta2,end=20) nbvec
  if(iosta2 /= 0) then
                  print*, 'iosta2=',iosta2
                  go to 20
  endif

  nblorej=0

  DO i=1,nbvec

  read(1,iostat=iosta2,end=20) datiso,bx,by,bz,px,py,pz
  if(iosta2 /= 0) then
                  print*, 'iosta2=',iosta2
                  go to 20
  endif
  
! passage en gsm

  read(datiso,'(i4,5(1x,i2))') iyear,imon,iday,ih,im,is

  call ctimpar(iyear,imon,iday,ih,im,is) 
  call t_gse_to_gsm(px,py,pz,pxg,pyg,pzg)
  call t_gse_to_gsm(bx,by,bz,bxg,byg,bzg)
  call g_gsm_dipole_tilt_angle(diptan)
  diptan=diptan*180./3.14159

! km -> RE

  RE=6372.2

  pxg=pxg/RE
  pyg=pyg/RE
  pzg=pzg/RE

  r=sqrt(pxg**2 +pyg**2 +pzg**2)
  
  if(r > 25. .or. r < 1.1) cycle
  
  VGSEX=-400.0 
  VGSEY=0.
  VGSEZ=0.
  call cdoyear(iyear,imon,iday,idoty)
  call RECALC_08 (IYEAR,idoty,ih,im,is,VGSEX,VGSEY,VGSEZ)
  call GDIPTIL(Tdiptan)
  Tdiptan=Tdiptan*180./3.14159
  
  if(abs(diptan-Tdiptan) > 1.) then
     nblorej=nblorej+1
     print*, '*** dipta, Tdiptan,diff=',diptan,Tdiptan,diptan-Tdiptan
     print*, '*** block rejected :',nblorej,' /',nbvec
     cycle
  endif
  
! on retire l'IGRF       

!   (3) IF NO   INFORMATION IS AVAILABLE ON THE SOLAR WIND SPEED, THEN SET VGSEX=-400.0
!       AND VGSEY=VGSEZ=0. IN THAT CASE,    THE GSW COORDINATE SYSTEM BECOMES
!       IDENTICAL TO    THE STANDARD ONE. 

!       call DIP_08 (pxg,pyg,pzg,HXGSW,HYGSW,HZGSW)
        call IGRF_GSW_08 (pxg,pyg,pzg,HXGSW,HYGSW,HZGSW)
        
        bxg=bxg -HXGSW
        byg=byg -HYGSW
        bzg=bzg -HZGSW
      
  nt=nt+1
  nf=nf+1


! calcul des grilles
! ------------------    
  
  if(diptan > 0) then
     kdta= int(( diptan+5.)/10.)
                 else
     kdta=-int((-diptan+5.)/10.)
  endif
  idta=kdta+5  ! varie entre 1 et 9 pour dta entre -35 et 35
  nbdta=9
  
  if(nt < 10) print*,'idta=',idta
  
  if(idta < 1 .or. idta > nbdta) cycle
  
  dtak= float(kdta)*10.

  igx=int((pxg-x1)/dx) +1
  igy=int((pyg-y1)/dy) +1
  igz=int((pzg-z1)/dz) +1
  
  if(nt < 10) print*, 'iclu,igx,igy,igz,idta=',iclu,igx,igy,igz,idta

  if(igx < 1 .or. igx > nx) cycle
  if(igy < 1 .or. igy > ny) cycle
  if(igz < 1 .or. igz > nz) cycle

! B ----------------------------
  nvalB(igx,igy,igz,idta)=nvalB(igx,igy,igz,idta) +1
  
  if(nt < 10) print*,'nvalb=',nvalB(igx,igy,igz,idta)

  gridB(1,igx,igy,igz,idta)=gridB(1,igx,igy,igz,idta) +bxg 
  gridB(2,igx,igy,igz,idta)=gridB(2,igx,igy,igz,idta) +byg 
  gridB(3,igx,igy,igz,idta)=gridB(3,igx,igy,igz,idta) +bzg 
  
  B0=sqrt(bxg**2 +byg**2 +bzg**2)

  gridB(4,igx,igy,igz,idta)=gridB(4,igx,igy,igz,idta) +B0
  
  ENDDO

 20 continue  ! pour EOF sur fichier en cours

  print*, trim(file_fgmpos),' nf, nt, nbvec=',nf,nt,nbvec

  ENDDO ! sur lecture de tous les fichiers
  
 30 continue ! tous les fichiers sont lus

  print*, 'nt=',nt
  print*
  print*,'grid creation, wait...'
  
! creation des fichiers grilles pour chaque valeur du dta
! -------------------------------------------------------

do idta=1,nbdta

  dta=float(idta-5)*10.
  kdta=INT(dta)
  write(cdta,'(i3.2)') abs(kdta)
  if(kdta >= 0) then
          cdta(1:1)='p'
                else
          cdta(1:1)='m'
  endif
  print*, '---------------------'
  print*, 'idta,cdta=',idta,cdta

  write(datafileB, '(a,3i3.3,3a)') 'grid_results/grid_Bxyz_',nx,ny,nz,'_',cdta,'.dat'

  open(11,file=datafileB)

  write(11,'(i8,1x,i8,1x,i8,1x,i1)') nx,ny,nz,4

  nb=0

! normalisation

  do i=1,nx
     do j=1,ny
        do k=1,nz
          if(nvalB(i,j,k,idta) /= 0) then
             Bxx=gridB(1,i,j,k,idta)/float(nvalB(i,j,k,idta))
             Byy=gridB(2,i,j,k,idta)/float(nvalB(i,j,k,idta))
             Bzz=gridB(3,i,j,k,idta)/float(nvalB(i,j,k,idta))
             B00=gridB(4,i,j,k,idta)/float(nvalB(i,j,k,idta))
             nb=nb+1
                              else
             Bxx=1.e30
             Byy=1.e30
             Bzz=1.e30
             B00=1.e30
          endif
          write(11,'(4E13.5,i8)') Bxx,Byy,Bzz,B00, nvalB(i,j,k,idta)
        enddo
     enddo
  enddo

  print*,trim(datafileB)

  print*,'grid dimension      b :',nx,ny,nz

  close(11)

enddo ! idta

  print*, ('-',i=1,72)

  print*, "    crea_grid_B_ini-igrf.exe  : NORMAL TERMINATION"
         stop "crea_grid_B_ini-igrf.exe  : NORMAL TERMINATION"

  end

! XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX

!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
       SUBROUTINE GDIPTIL(PS)
!
!-----INPUT PARAMETERS:  NONE
!-----OUTPUT PARAMETERS: PS - GEODIPOLE TILT ANGLE IN RADIANS
!
!     ATTENTION:  SUBROUTINE  RECALC  MUST BE INVOKED BEFORE GDIPTIL IN
!     TWO CASES:
!     /A/  BEFORE THE FIRST INVOCATION OF GDIPTIL
!     /B/  IF THE VALUES OF IYEAR,IDAY,IHOUR,MIN,ISEC HAVE BEEN CHANGED
!
!     P. Robert, June 2002.
!
!                      ----------------------
!
      COMMON /GEOPACK1/ A(12),DS3,BB(2),PSI,CC(18)
!
      PS=PSI
!
      RETURN
      END
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX


