  program curl_div_gse_to_gsm
  
  
! -----------------------------------------------------------------------------
! Frame   : Procedures and program used in JGR data report 
!           "Use of twenty years CLUSTER/FGM data to observe the mean behavior 
!           of the magnetic field and current density of Earth's magnetosphere" 
!           By P. Robert and M. Dunlop, October 2021
!
! Program : curl_div_gse_to_gsm.f90
! Object  : Convert a Curl file from GSE to GSM system
! Input   : path of a Curl file in GSE system (from data base)
! Output  : Curl file in GSM system (created in working directory)
! Author  : P. Robert, LPP-ScientiDev, 2020-Oct.2021
! Mail    : patrick.robert@lpp.polytechnique.fr
! -----------------------------------------------------------------------------

  real(kind=4), dimension(4) :: Pxe,Pye,Pze,Bxe,Bye,Bze,Px,Py,Pz,Bx,By,Bz
  
  character(len=255)         :: file_curl_div,file_curl_div_gsm
  character(len=24)          :: datiso
  
  logical                    :: file_exists

  
  print*
  print*,'-----------------------------------'
  print*,'curl_div_gse_to_gsm.exe'
  print*,'-----------------------------------'
  print*
  print*, 'path of gse file to read ? (ex: ../DATA_PRo/DATA_Curl_Div_raw/2009/2009_09/Curl_FGM_SPIN_20090910.dat)'
  read(*,'(a)', iostat=iosta) file_curl_div
  
  if(iosta /= 0) stop '*** curl_div_gse_to_gsm : bad filename'
  print*, 'file to read: ',trim(file_curl_div)
  
  INQUIRE(FILE=trim(file_curl_div), EXIST=file_exists)
  print*,file_exists
  
  i=index(file_curl_div,'/',back=.true.)
  j=index(file_curl_div,'.dat')
  file_curl_div_gsm=file_curl_div(i+1:j-1)//'_gsm.dat'
  
  if(file_exists) then
     open(1, file=file_curl_div)
     open(2, file=file_curl_div_gsm)
                  else
     stop '*** curl_div_gse_to_gsm : input file does not exist'
  endif

! read number of blocks
  
  read (1,*,iostat=iosta) nbloc
  write(2,*) nbloc
  print*, 'read ',trim(file_curl_div),'  nbloc=',nbloc

! read all the file

  DO n=1,nbloc
  
  read(1,200,iostat=iosta2,end=20) datiso,Pxe,Pye,Pze,Bxe,Bye,Bze,GJxe,GJye,GJze,curl,div,ajb,elong,plana,diptan 
  200 format(a24,/,12E14.6,/,12E14.6,/,6E11.3,2E10.2,E11.3)

  if(iosta2 /= 0)  stop '*** curl_div_gse_to_gsm : error during reading file' 
  
  if(n < 10) then
      print*,'---------------------------------'
      print*,'n=',n    
      print*,'datiso=',datiso
      print*,'Pxe=',Pxe
      print*,'Pye=',Pye
      print*,'Pze=',Pze
      print*
      print*,'Bxe=',Bxe
      print*,'Bye=',Bye
      print*,'Bze=',Bze
      print*
      print*,'Jxe=',Gjxe
      print*,'Jxe=',Gjye
      print*,'Jxe=',Gjze
      print*
      print*,'curl=',curl
      print*,'div =',div
      print*,'ajb=',ajb
      print*,'elong,plana=',elong,plana
      print*,'diptan=',diptan
      print*
  endif  
  
  if(n==11) print*,'Please wait during conversion GSE to GSM...'
  
! convert to gsm

  call decode_datiso(datiso,iyear,imon,iday,ih,im,is,ims,imc) 
  call ctimpar(iyear,imon,iday,ih,im,is)
      
  do isat=1,4    
      call t_gse_to_gsm(Pxe(isat),Pye(isat),Pze(isat),Px(isat),Py(isat),Pz(isat))
      call t_gse_to_gsm(Bxe(isat),Bye(isat),Bze(isat),Bx(isat),By(isat),Bz(isat))
  enddo
  
  call t_gse_to_gsm(GJxe,GJye,GJze,GJx,GJy,GJz)
  
  write(2,200) datiso,Px,Py,Pz,Bx,By,Bz,GJx,GJy,GJz,curl,div,ajb,elong,plana,diptan
  
  ENDDO
  
  print*
  print*,'all ',n,' records have been read and converted in GSM'
  print*, 'file ',trim(file_curl_div_gsm),' is available in same format'
  close(1)
  close(2)
  stop '    curl_div_gse_to_gsm : NORMAL TERMINATION'
  
  20 continue
  stop '*** curl_div_gse_to_gsm : ABNORMAL TERMINATION'
  end
