
 program fgm_cef_to_dat
  
! -----------------------------------------------------------------------------
! Frame   : Procedures and program used in JGR data report 
!           "Use of twenty years CLUSTER/FGM data to observe the mean behavior 
!           of the magnetic field and current density of Earth's magnetosphere" 
!           By P. Robert and M. Dunlop, October 2021
!
! Program : fgm_cef_to_dat.f90
! Object  : Read an ascii FGM cef file and convert it in a binary FGM dat file
! Input   : name of a FGM cef file
! Output  : binary FGM file
! Author  : P. Robert, LPP-ScientiDev, 2020-Oct.2021
! Mail    : patrick.robert@lpp.polytechnique.fr
! -----------------------------------------------------------------------------
  
   
 character(len=24)  :: datiso
 character(len=10)  :: start
 character(len= 9)  :: recnum
 character(len=255) :: ligne,file1,file2
 
 start='DATA_UNTIL'
 recnum='!RECORDS='
 
 print*, 'name of cef file ? (ex: C3_CP_FGM_SPIN__20010110_000000_20010110_020000)'
 read(*,'(a)') file1
 
 ! CEF_database_CLUSTER/FGM/SPIN/2018/2018_01/C2_CP_FGM_SPIN__20180121.cef
 ! CEF_database_CLUSTER/FGM/SPIN/2018/2018_01/C2_CP_FGM_SPIN__20040130_163000_20040130_170000.cef
 
 !fgmpos: C4_FGM_SPIN_20090905.dat
 
 file2=file1(1:3)//file1(7:14)//file1(16:24)//'.dat'
 
 print*,'input file : ',trim(file1)
 print*,'output file: ',trim(file2)

 
!  2001-01-10T00:00:00.584Z,2,2.823,-10.455,8.026,13.479,38310.7,80052.3,54400.4,2,22  
 
 open(1,file=file1,status='old')
 open(2,file=file2,form='unformatted')
 
 20 continue
    read(1,'(a)') ligne
    if(ligne(1:9) == recnum) then
       read(ligne(10:255),*) nbvec
       print*, 'nbvec=',nbvec
       write(2) nbvec
       go to 10
    endif
    go to 20

 10 continue
 
    rewind(1)
    
    do while (ligne(1:10) /= start)
       read(1,'(a10)') ligne(1:10)
    enddo
    
    do i=1,nbvec
    read (1,*) datiso,ibid,bx,by,bz,b0,px,py,pz
    write(2) datiso,bx,by,bz,px,py,pz
    enddo
 
    close(1)
    close(2)
   
 stop 'OK fgm_cef_to_dat'
 end
 
 
 
 
 