! -----------------------------------------------------------------------------
! Frame   : Procedures and program used in JGR data report 
!           "Use of twenty years CLUSTER/FGM data to observe the mean behavior 
!           of the magnetic field and current density of Earth's magnetosphere" 
!           By P. Robert and M. Dunlop, October 2021
!
! Library : read_3D_grid.f90
! Object  : routine for reading a 3D grid
! Author  : P. Robert, LPP-ScientiDev, 2020-Oct.2021
! Mail    : patrick.robert@lpp.polytechnique.fr
! -----------------------------------------------------------------------------

! XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
  
  module dim_grid
  
  real(kind=4), dimension(:,:,:), allocatable   :: grid_Vx, grid_Vy, grid_Vz, grid_V0
  real(kind=4), dimension(:,:,:), allocatable   :: gri_div, gri_dsc, gri_abj
  integer     , dimension(:,:,:), allocatable   :: nval
  integer     , dimension(:,:),   allocatable   :: nval_2D
  integer     , dimension(:,:),   allocatable   :: imagexz,imagexy,imageyz
  
  real(kind=4), dimension(:,:),   allocatable   :: grid_2D
  real(kind=4), dimension(:),     allocatable   :: gri_Px, gri_Py, gri_Pz

  integer :: nx,ny,nz,nbvec
  real(kind=4) :: x1,y1,z1,x2,y2,z2,dx,dy,dz
  
  end module dim_grid

! XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
  
  subroutine read_grid3D(ifc,grid_name)
  
  use dim_grid
  
  character(len=*) :: grid_name
  
  x1=-20.
  x2= 20.
  y1=-20.
  y2= 20.
  z1=-20.
  z2= 20.

  iosta=0
  n=0
  
  print*, '--------------------------------'
  print*, 'reading ',trim(grid_name)
  close(ifc)
  open(ifc,file=grid_name)
  read(ifc,*) nx,ny,nz, nbvec
  print*, 'nx,ny,nz,nbvec=',nx,ny,nz,nbvec,' ie ntot=',nx*ny*nz
  
  if(nbvec /= 1 .and. nbvec /= 4 .and. nbvec /=7) stop 'nbvec only 4 or 7'
  
  dx=(x2-x1)/float(nx)
  dy=(y2-y1)/float(ny)
  dz=(z2-z1)/float(nz)
  
  allocate(nval(nx,ny,nz))
  nval(:,:,:)=0
  
! B or J
  if(nbvec == 4 .or. nbvec == 7) then 
     allocate(grid_Vx(nx,ny,nz))
     allocate(grid_Vy(nx,ny,nz))
     allocate(grid_Vz(nx,ny,nz))
     allocate(grid_V0(nx,ny,nz))

     grid_Vx(:,:,:)=0.
     grid_Vy(:,:,:)=0.
     grid_Vz(:,:,:)=0.
     grid_V0(:,:,:)=0.
  endif
  
! J only 

  if(nbvec == 7) then
     allocate(gri_div(nx,ny,nz))
     allocate(gri_dsc(nx,ny,nz))
     allocate(gri_abj(nx,ny,nz))
     
     gri_div(:,:,:)=0.
     gri_dsc(:,:,:)=0.
     gri_abj(:,:,:)=0.
  endif

  ntot=0
  nvt =0
  ipcp=0
  
  write(*,*)
  write(*,'("reading...  ",i9," points")') nx*ny*nz

  do i=1,nx
  ipc=int(100.*float(i)/float(nx))
  if(ipc /= ipcp) write(*,'("reading...  ",i3," %")') ipc
  ipcp=ipc
  
  do j=1,ny
     do k=1,nz
        if(nbvec == 4) read(ifc,*,end=10) grid_Vx(i,j,k),grid_Vy(i,j,k),grid_Vz(i,j,k), grid_V0(i,j,k),nval(i,j,k) 
        if(nbvec == 7) read(ifc,*,end=10) grid_Vx(i,j,k),grid_Vy(i,j,k),grid_Vz(i,j,k), grid_V0(i,j,k), &
                                          gri_div(i,j,k),gri_dsc(i,j,k),gri_abj(i,j,k), nval(i,j,k)                 
        if(nbvec == 1) read(ifc,*,end=10) grid_V0(i,j,k),nval(i,j,k) 
        ntot=ntot+1
        nvt =nvt +nval(i,j,k)
     enddo
  enddo
  enddo

 10 continue
 
  ipc=100
  write(*,'("read !!!     ",i3," %")') ipc
  write(*,*)
  
  close(ifc)


  print*, '3D grid data are read, nvt,ntot=',nvt,ntot
  print*, '--------------------------------'
  
  return
  end 

! XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX

  subroutine alloc_grid1D()
  
  use dim_grid

  allocate(gri_Px(nx))
  allocate(gri_Py(ny))
  allocate(gri_Pz(nz))

  dx=(x2-x1)/float(nx)
  dy=(y2-y1)/float(ny)
  dz=(z2-z1)/float(nz)

  do i=1,nx
     gri_Px(i)=float(i-1)*dx +x1 +0.5*dx
  enddo

  do j=1,ny
     gri_Py(j)=float(j-1)*dy +y1 +0.5*dy
  enddo

  do k=1,nz
     gri_Pz(k)=float(k-1)*dz +z1 +0.5*dz 
  enddo
!-----------------------------------------------------

  return
  end 
  
! XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX 

