  program read_bin_dat
  
! -----------------------------------------------------------------------------
! Frame   : Procedures and program used in JGR data report 
!           "Use of twenty years CLUSTER/FGM data to observe the mean behavior 
!           of the magnetic field and current density of Earth's magnetosphere" 
!           By P. Robert and M. Dunlop, October 2021
!
! Program : read_dat
! Object  : read a *.dat binary dat file of the FGMPOS_database
! Input   : path of a binary dat file
! Output  : firts 10 records converted in ASCII
! Author  : P. Robert, LPP-ScientiDev, 2020-Oct.2021
! Mail    : patrick.robert@lpp.polytechnique.fr
! -----------------------------------------------------------------------------
  
  character*255 file_fgmpos
  character*24 datiso
  logical                    :: file_exists


  print*
  print*,'-----------------------------------'
  print*,'read_bin_dat.exe'
  print*,'-----------------------------------'
  print*

! read data file path and check if exists
  
  print*, 'path of file to read ? (ex: FGMPOS_database/2009/2009_09/C4_FGM_SPIN_20090905.dat)'
  read(*,'(a)', iostat=iosta) file_fgmpos
  
  if(iosta /= 0) stop '*** read_ascii_dat : bad filename'
  print*, 'file to read: ',trim(file_fgmpos)
  
  inquire(file=trim(file_fgmpos), exist=file_exists)
  print*,file_exists
  
  if(file_exists) then
     open(1, file=file_fgmpos,form='unformatted')
                  else
     stop '*** read_ascii_dat : input file does not exist'
  endif

! read number of blocks  

  read(1,iostat=iosta) nbloc
  print*, 'read ',trim(file_fgmpos),'  nbloc=',nbloc
  
! read data and print first 10
  
  do n=1,nbloc
     read(1,iostat=iosta,end=20) datiso, bx,by,bz, px,py,pz
     if(iosta /= 0) stop '*** read_bin_dat : error during reading file' 
     print*,datiso, bx,by,bz, px,py,pz
  enddo
  
  close(1) 
  print*
  print*,'all ',n,' records have been read'
  stop '    read_bin_dat : NORMAL TERMINATION'
  
  20 continue
  stop '*** read_bin_dat : ABNORMAL TERMINATION'
  end
  
